/*------------------------------------------------------------------------------*
 * File Name: Tree.h															*
 * Creation: TD 12-19-02														*
 * Purpose: Origin C support for a general Tree/TreeNode						*
 * Copyright (c) OriginLab Corp.2003											*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:07/25/03_PRITHVI_ADDED_DOCUMENTATION_FOR_METHODS_IN_		*
 *					TREENODE_CLASS												*
 *  SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP					*
 *	ML 12/19/2007 QA70-10847 SETTING_TEXT_NODE_WITH_SPECIFIED_CODEPAGE			*
 *	Kyle 10/13/08 COMPARE_TO_TREE_AND_CREATE_A_TREE_FROM_THE_DIRRERENCE			*
 *	Sim 11-26-2008 QA80-12318 TREE_DOUBLE_VALUE_COMPARE							*
 *	Hong 11/11/09 QA80-14625 TREE_EDIT_CTRL_DISPLAY_VECTOR_TREENODE_AS_DEBUG_VARIABLE_TAB
 *	Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG		*
 *------------------------------------------------------------------------------*/

 
#ifndef _TREE_H
#define _TREE_H


#include <common.h>
#include <Collection.h>

///Comments last updated by Joseph on 03/08/2007
/**+
http://ocwiki.originlab.com/index.php?title=Category:PropertyNode_(class)
*/
class PropertyNode
{
public:

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-PropertyNode
	*/
	PropertyNode();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-PropertyNode
	*/
	PropertyNode(PropertyNode &tn);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-nVal
	*/
	int    				nVal;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-dVal
	*/
	double 				dVal;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-strVal
	*/
	string				strVal;
	
	// vector data
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-dVals
	*/
	vector<double>		dVals;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-fVals
	*/
	vector<float>		fVals;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-nVals
	*/
	vector<int>			nVals;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-sVals
	*/
	vector<short>		sVals;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-bVals
	*/
	vector<char>		bVals;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-strVals
	*/
	vector<string>      strVals;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-dVals2
	*/
	matrix<double>		dVals2;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-fVals2
	*/
	matrix<float>		fVals2;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-nVals2
	*/
	matrix<int>			nVals2;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-sVals2
	*/
	matrix<short>		sVals2;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-bVals2
	*/
	matrix<char>		bVals2;
	
#if _OC_VER >= 0x0800
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:PropertyNode-pict
	*/
	PictureHolder		pict;
	
#endif //#if _OC_VER >= 0x0800


};

/**+
http://ocwiki.originlab.com/index.php?title=Category:TreeNode_(class)
*/
class TreeNode :public PropertyNode
{
public:
	
	// Comments last updated by Kevin on 08/23/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-TreeNode
	*/
	TreeNode(); //Default constructor

	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-TreeNode
	*/
	TreeNode(TreeNode &tn);//Copy Constructor
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Text
	*/
	string 				Text;		
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-nVal
	*/
	int    				nVal;	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-dVal
	*/
	double 				dVal;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-strVal
	*/
	string				strVal;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-ID
	*/
	int					ID;	// attribute NodeID
	//---- the followings are the same as attribute names and -1 if attribute not in node
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Show
	*/
	int					Show;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Enable
	*/
	int					Enable; 
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Use
	*/
	int					Use;
	//----
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-DataID
	*/
	int					DataID;
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-TypeID
	*/
	int					TypeID;

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-tagName
	*/
	string				tagName;		//read only

	// iterators -- syntax similar to C#
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-FirstNode
	*/
	TreeNode			FirstNode;		//read only
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-NextNode
	*/
	TreeNode			NextNode;		//read only
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-PrevNode
	*/
	TreeNode			PrevNode;		//read only
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-LastNode
	*/
	TreeNode			LastNode;		//read only

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-NextLeaf
	*/
	TreeNode			NextLeaf;		//readOnly
	
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Kevin on 08/23/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetNode
	*/
	TreeNode			GetNode(LPCSTR Name, BOOL bCaseSensitive=true); // Find child by name
	
	///Kyle 10/13/08 COMPARE_TO_TREE_AND_CREATE_A_TREE_FROM_THE_DIRRERENCE
	// Last updated by Kyle, 12-24-2008
	/**$
		Construct a new tree that collects all the tree nodes that are different between the two given.
		
		Parameters:
			dwCntrl = [input]
				TRDIFF_CHK_ATTRIB		  	compare both value and attribute
				TRDIFF_KEEP_INDIVI_TARGET  	consider diff if node missing in tnRef but exsits in tnTarget,
											if TRDIFF_KEEP_REF_VALUES set, a attribute named STR_TRDIFF_REF_VALUE_ATTRIB will be set, and the attribute value is Empty
				TRDIFF_KEEP_INDIVI_REF		consider diff if node missing in tnTarget but exists in tnRef
											if TRDIFF_KEEP_REF_VALUES set, values will be kept as attribute named STR_TRDIFF_REF_VALUE_ATTRIB, otherwise they will be kept as value
				TRDIFF_KEEP_BRANCH_NO_LEAF	keep such branch even if no any childens diff, etc. category branch
				TRDIFF_KEEP_REF_VALUES		keep the values in tnRef as attribute(named STR_TRDIFF_REF_VALUE_ATTRIB) if the node's value is different from the value of the corresponding node in tnTarget
				TRDIFF_BY_NODE_INDEX		check diff by index of children node
			nRealPrecision = [input] for compare double value
				default = 0, means origin default
					-1, means full precision
			
		Return:
		  -1 if error, like tnTarget or tnRef invalid
		  0 if no diff
		  >0 for number of diff nodes found
		  
		Remark:
			when dwCntrl = 0, this function will only look at treenodes that are present in both trees and only values will be checked.
			Please also note that the two trees are assumed to have same branch structures, such that when a nide is missing, the comparison is done only inside the current branch being compared.
			
		Examples:
			void test_create_diff_ex1()
			{
				Tree tr1;
				tr1.node1.nVal = 1;
				tr1.branch.node2.dVal = 2.3;
				tr1.branch.node3.strVal = "abc";
				
				Tree tr2;
				tr2.node10.nVal = 1;
				tr2.branch.node2.dVal = 2.3;
				tr2.branch.node3.strVal = "edf";
				
				Tree trDiff;
				trDiff.CreateDiff(tr1, tr2, TRDIFF_KEEP_INDIVI_TARGET);
				
				out_tree(tr1);
				out_tree(tr2);
				out_tree(trDiff);
				ASSERT(trDiff.node1.nVal == 1);
				ASSERT(trDiff.branch.node3.strVal == "abc");
			}
  	*/
	///---Sim 11-26-2008 QA80-12318 TREE_DOUBLE_VALUE_COMPARE
	//int 				CreateDiff(const TreeNode& tn1, const TreeNode& tn2, DWORD dwCntrl = 0);
	///------ Folger 11/11/09 QA81-14630 SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	//int 				CreateDiff(const TreeNode& tnTarget, const TreeNode& tnRef, DWORD dwCntrl = 0, int nRealPrecision = 0);
	int 				CreateDiff(const TreeNode& tnTarget, const TreeNode& tnRef, DWORD dwCntrl = 0, int nRealPrecision = 0, LPCSTR lpcszAttribs = NULL);
	///------ End SUPPORT_DUMPING_XF_SETTINGS_FROM_GETN_DIALOG
	///---END QA80-12318 TREE_DOUBLE_VALUE_COMPARE
	///End COMPARE_TO_TREE_AND_CREATE_A_TREE_FROM_THE_DIRRERENCE



	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Kevin on 08/23/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-FindNodeByAttribute
	*/
	TreeNode			FindNodeByAttribute(LPCSTR AttributeName, int nVal, BOOL bRecursive = TRUE); // Find child by Attribute value
	
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Kevin on 08/23/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-FindNodeByAttribute
	*/
	TreeNode			FindNodeByAttribute(LPCSTR AttributeName, LPCSTR lpcszValue, BOOL bRecursive = TRUE, BOOL bCaseSensitive = FALSE);
	
	// Comments last updated by Kevin on 08/23/2005
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Parent
	*/
	TreeNode			Parent(); // Find parent -- Null if parent is not an element node
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Clone
	*/
	TreeNode			Clone(BOOL bDeep = TRUE); // Clones a Node, if bDeep is true, copies the whole branch

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Reset
	*/
	void	Reset(BOOL bKeepAttributes = false);	
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-AddNode
	*/
	BOOL				AddNode(TreeNode &tn, BOOL bDeep = TRUE);
	// Comments last updated by Hong on 04/28/07
 	/**+
_	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-InsertNode
 	*/
	TreeNode		 InsertNode(const TreeNode& trBefore, LPCSTR lpcszTagName, int nChildID = -1);

	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Replace
	*/
	BOOL				Replace(TreeNode &tn, BOOL bDeep = TRUE, BOOL bKeepTagName = FALSE, BOOL bKeepAttributes = FALSE);

	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetNodeCount
	*/
	int					GetNodeCount();
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-AddNode
	*/
	TreeNode			AddNode(LPCSTR Name = NULL, int nChildID = -1); //NodeID will not be created if < 0
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-AddNumericNode
	*/
	TreeNode			AddNumericNode(double  dVal, LPCSTR Name = NULL, int nChildID = -1);
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-AddNumericNode
	*/
	TreeNode			AddNumericNode(int nVal, LPCSTR Name = NULL, int nChildID = -1);
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-AddTextNode
	*/
	/// ML 12/19/2007 QA70-10847 SETTING_TEXT_NODE_WITH_SPECIFIED_CODEPAGE
	//TreeNode			AddTextNode(LPCSTR strVal, LPCSTR Name = NULL, int nChildID = -1, BOOL bSetAsCDATA = FALSE);
	TreeNode			AddTextNode(LPCSTR strVal, LPCSTR Name = NULL, int nChildID = -1, BOOL bSetAsCDATA = FALSE, int nCodePage = -1);
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetNodeText
	*/
	string				GetNodeText(int nCodePage = -1);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetNodeText
	*/
	BOOL				SetNodeText(LPCSTR lpcszVal, int nCodePage = -1);
	/// end SETTING_TEXT_NODE_WITH_SPECIFIED_CODEPAGE

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetCDATA
	*/
	BOOL				SetCDATA(bool bSet = true);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetAttribute
	*/
	BOOL				GetAttribute(LPCSTR lpcszAttrName, 	int &nVal);
	
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetAttribute
	*/
	BOOL				GetAttribute(LPCSTR lpcszAttrName, 	double  &dVal);
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetAttribute
	*/
	BOOL				GetAttribute(LPCSTR lpcszAttrName, 	string &strVal);
	
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetAttribute
	*/
	BOOL				SetAttribute(LPCSTR lpcszAttrName, int nVal);
	
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetAttribute
	*/
	BOOL				SetAttribute(LPCSTR lpcszAttrName, double  dVal);
	
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetAttribute
	*/
	BOOL				SetAttribute(LPCSTR lpcszAttrName, LPCSTR strVal);

	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-RemoveAttribute
	*/
	BOOL				RemoveAttribute(LPCSTR lpcszAttrName);
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-RemoveChild
	*/
	BOOL				RemoveChild(int nChildID);
	
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-RemoveChild
	*/
	BOOL				RemoveChild(LPCSTR Name);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-RemoveChild
	*/
	BOOL				RemoveChild(TreeNode &tn);
	
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-RemoveChildrenWithPrefix
	*/
	int					RemoveChildrenWithPrefix(LPCSTR lpcszPrefix = NULL);
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Remove
	*/
	BOOL				Remove();
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-IsValid
	*/
	BOOL				IsValid();
	
	/**
	*/
	/// SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP
	// Removed, should be done from other end - range getting tree as reference
	///BOOL				SetRange(int r1, int c1, int r2, int c2);
	/// end IMPORT_INFO_STORAGE_CLEANUP
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetDataRange
	*/
	BOOL 		SetDataRange(DataRange& dRange, DWORD dwDisplaySettings = 0);
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetDataRange
	*/
	BOOL 		GetDataRange(DataRange& dRange);

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-IsEmpty
	*/
	BOOL				IsEmpty();
	
	/**
	*/
	/// SY 09/01/2004 QA70-6472 v8.0128 IMPORT_INFO_STORAGE_CLEANUP
	// Removed, should be done from other end - range getting tree as reference
	///BOOL				GetRange(int &r1, int &c1, int &r2, int &c2);
	/// end IMPORT_INFO_STORAGE_CLEANUP

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Children
	*/
	Collection<TreeNode>	Children;
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-XML
	*/
	string				XML;	// init treenode from XML string or to get as XML string
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/// TD 7-22-04 QA70-6713 VALUE_SETTINGS_TO_LINEARIZED_TREE
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetValue
	*/
	BOOL SetValue(int nval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetValue
	*/
	BOOL SetValue(double dval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetValue
	*/
	BOOL SetValue(string strval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-SetValue
	*/
	BOOL SetValue(const vectorbase& vval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);

	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetValue
	*/
	BOOL GetValue(int &nval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetValue
	*/
	BOOL GetValue(double &dval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	// Comments last updated by Hong on 04/28/07
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetValue
	*/
	BOOL GetValue(string &strval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetValue
	*/
	BOOL GetValue(vectorbase& vval, LPCSTR lpcszPropName = NULL, BOOL bRecusrive = FALSE, BOOL bAll = FALSE);
	/// end VALUE_SETTINGS_TO_LINEARIZED_TREE

	// Comments last updated by Hong on 04/28/07
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-Reverse
	*/
	BOOL Reverse();//CPY 8/14/05

	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:TreeNode-GetAttributeNames
	*/
	BOOL GetAttributeNames(vector<string>& vsNames);
	
	/// Hong 11/11/09 QA80-14625 TREE_EDIT_CTRL_DISPLAY_VECTOR_TREENODE_AS_DEBUG_VARIABLE_TAB
	/**$
	*/
	BOOL GetArrayAsString(string& strVal, BOOL bDotted = TRUE);
	/// end TREE_EDIT_CTRL_DISPLAY_VECTOR_TREENODE_AS_DEBUG_VARIABLE_TAB
};


/**+
http://ocwiki.originlab.com/index.php?title=Category:Tree_(class)
*/
class Tree : public TreeNode
{
	
public:
	
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Tree-Tree
	*/
	Tree(LPCSTR File, int nType = 0);
	
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Tree-Tree
	*/
	Tree(int nType = 0);
	
	// Comments last updated by Frank on 08/09/05
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Tree-Load
	*/
	BOOL	Load(LPCSTR File, int nType = 0);
	
	
	/**+
	http://ocwiki.originlab.com/index.php?title=OriginC:Tree-Save
	*/
	BOOL	Save(LPCSTR lpcszFile);
};



/**+
http://ocwiki.originlab.com/index.php?title=Category:TreeNodeCollection_(class)
*/
class TreeNodeCollection : public Collection<TreeNode>
{
	public:

		// Comments last updated by Hong on 04/28/07
		// Comments last updated by Frank on 08/09/05
		/**+
		http://ocwiki.originlab.com/index.php?title=OriginC:TreeNodeCollection-TreeNodeCollection
		*/
		TreeNodeCollection(TreeNode node, LPCSTR lpcsz);
};
#endif //_TREE_H
